﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class PromotionBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static Promotion GetItem(Guid promotionID, DateTime startDate, DateTime endDate, string keyword)
        {
            return PromotionDB.GetItem(promotionID, startDate, endDate, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<Promotion> GetList(Guid promotionID, DateTime startDate, DateTime endDate, string keyword)
        {
            return PromotionDB.GetList(promotionID, startDate, endDate, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid promotionID, DateTime startDate, DateTime endDate, string keyword)
        {
            return PromotionDB.GetDataTable(promotionID, startDate, endDate, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid promotionID, DateTime startDate, DateTime endDate, string keyword)
        {
            return PromotionDB.GetDataSet(promotionID, startDate, endDate, Utilities.ValidationUtility.ReplaceWildcardCharactersForSQL(keyword));
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(Promotion myPromotion)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                PromotionDB.Save(myPromotion);

                foreach (PromotionDetails myPromotionDetails in myPromotion.PromotionDetailsList)
                {
                    myPromotionDetails.PromotionID = myPromotion.UniqueID;
                    PromotionDetailsDB.Save(myPromotionDetails);
                }

                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
